/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.Gui.comp;

import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.FrameGrip;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.GuiList;
import cd4017be.lib.Gui.comp.IGuiComp;
import cd4017be.lib.Gui.comp.TextField;
import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class FileBrowser
extends GuiFrame
implements ObjIntConsumer<GuiList>,
Supplier<String>,
Consumer<String> {
    private static final String PRE_DIR = "\u00a7e";
    private static final String PRE_FILE = "\u00a7f";
    private static final String BACK = "\u00a7e<--";
    static final ResourceLocation TEX = new ResourceLocation("cd4017be_lib", "textures/gui/file.png");
    final Consumer<FileBrowser> action;
    final Predicate<String> filter;
    File dir = new File("");
    String file = "";

    public FileBrowser(GuiFrame parent, Consumer<FileBrowser> action, Predicate<String> filter) {
        super(parent, 248, 148, 5);
        this.background(TEX, 0, 0);
        new GuiList(this, this.w - 24, 9, 8, 24, 12, this).scrollbar(7, 12, 248, 0);
        new TextField(this, this.w - 25, 7, 8, 133, 128, this, this);
        new Button(this, 9, 9, this.w - 16, 132, 0, null, i -> action.accept(this)).tooltip("gui.cd4017be.sel_file");
        new FrameGrip(this, 8, 8, 0, 0);
        new Button(this, 8, 8, this.w - 8, 0, 0, null, i -> this.close()).tooltip("gui.cd4017be.close");
        this.action = action;
        this.filter = filter;
        parent.setFocus(this);
    }

    @Override
    public void drawBackground(int mx, int my, float t) {
        GlStateManager.func_179097_i();
        super.drawBackground(mx, my, t);
        String path = this.dir.getPath() + "/";
        if (this.fontRenderer.func_78256_a(path) > this.w - 16) {
            path = "..." + this.fontRenderer.func_78262_a(path, this.w - 16 - this.fontRenderer.func_78256_a("..."), true);
        }
        this.fontRenderer.func_78276_b(path, this.x + 8, this.y + 16, -14671840);
        GlStateManager.func_179126_j();
    }

    public void close() {
        this.parent.remove(this);
    }

    public FileBrowser setFile(File file) {
        this.dir = file.getParentFile();
        this.file = file.getName();
        this.updateDir((GuiList)this.get(0));
        return this;
    }

    public File getFile() {
        return new File(this.dir, this.file);
    }

    private void updateDir(GuiList t) {
        File[] files = this.dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        Object[] names = new String[files.length + 1];
        names[0] = BACK;
        int n = 1;
        int j = 1;
        for (File file : files) {
            if (file.isDirectory()) {
                names[n++] = names[j];
                names[j++] = PRE_DIR + file.getName() + "/";
                continue;
            }
            String s = file.getName();
            if (this.filter != null && !this.filter.test(s)) continue;
            names[n++] = PRE_FILE + s;
        }
        if (n < names.length) {
            names = Arrays.copyOf(names, n);
        }
        Arrays.sort(names, 1, n);
        t.setElements((String[])names);
        this.setFocus(t);
    }

    @Override
    public void accept(GuiList t, int value) {
        if (value <= 0) {
            File parent = this.dir.getParentFile();
            if (parent != null) {
                this.dir = parent;
            }
        } else {
            String s = t.elements[value];
            if (s.startsWith(PRE_DIR) && s.endsWith("/")) {
                this.dir = new File(this.dir, s.substring(PRE_DIR.length(), s.length() - 1));
            } else {
                this.file = s.substring(PRE_FILE.length());
                this.setFocus((IGuiComp)this.get(2));
                return;
            }
        }
        this.updateDir(t);
    }

    @Override
    public String get() {
        return this.file;
    }

    @Override
    public void accept(String t) {
        if (this.filter == null || this.filter.test(t)) {
            this.file = t;
        }
    }
}

