/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.wire;

import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.IIntegratedConnector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.ITagableConnector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.RelayPort;
import cd4017be.api.rs_ctr.wire.WireLine;
import cd4017be.lib.util.DimPos;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class WiredConnector
extends Connector
implements IPortProvider,
ITagableConnector {
    public final Port conBeacon;
    public DimPos conPos;
    public int conPin;
    protected String tag;

    public WiredConnector(MountedPort port) {
        super(port);
        this.conBeacon = new Port(this, 0, WiredConnector.class, port.isMaster);
    }

    @Override
    public void onLoad() {
        this.conBeacon.onLoad();
    }

    @Override
    public void onUnload() {
        this.conBeacon.onUnload();
    }

    @Override
    public Port getPort(int pin) {
        return this.conBeacon;
    }

    @Override
    public Object getPortCallback(int pin) {
        return this;
    }

    @Override
    public void setPortCallback(int pin, Object callback) {
        if (!(callback instanceof WiredConnector)) {
            return;
        }
        WiredConnector link = (WiredConnector)callback;
        boolean moved = false;
        DimPos pos = new DimPos((Vec3i)this.port.getPos(), this.port.getWorld());
        if (link.conPin != this.port.pin || !pos.equals((Object)link.conPos)) {
            link.conPin = this.port.pin;
            link.conPos = pos;
            link.onPortModified(link.conBeacon, 16);
            moved = true;
        }
        pos = new DimPos((Vec3i)link.port.getPos(), link.port.getWorld());
        if (this.conPin != link.port.pin || !pos.equals((Object)this.conPos)) {
            this.conPin = link.port.pin;
            this.conPos = pos;
            this.onPortModified(this.conBeacon, 16);
            moved = true;
        }
        if (moved) {
            this.onPortMove();
        }
    }

    @Override
    public void onPortModified(Port port, int event) {
        this.port.owner.onPortModified(this.port, 16);
    }

    protected void onMoved(WiredConnector link) {
    }

    @Override
    public void onPortMove() {
        WiredConnector p = this.getLink();
        if (p == null) {
            return;
        }
        this.onMoved(p);
        p.onMoved(this);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_179237_a(this.conBeacon.serializeNBT());
        nbt.func_74768_a("lp", this.conPin);
        nbt.func_74768_a("lx", this.conPos.func_177958_n());
        nbt.func_74768_a("ly", this.conPos.func_177956_o());
        nbt.func_74768_a("lz", this.conPos.func_177952_p());
        nbt.func_74768_a("ld", this.conPos.dimId);
        if (this.tag != null) {
            nbt.func_74778_a("tag", this.tag);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.conBeacon.deserializeNBT(nbt);
        this.conPin = nbt.func_74762_e("lp");
        this.conPos = new DimPos(nbt.func_74762_e("lx"), nbt.func_74762_e("ly"), nbt.func_74762_e("lz"), nbt.func_74762_e("ld"));
        this.tag = nbt.func_150297_b("tag", 8) ? nbt.func_74779_i("tag") : null;
    }

    public WiredConnector getLink() {
        int lid = this.conBeacon.getLink();
        if (lid == 0 || this.conPos == null) {
            return null;
        }
        Port lp = IPortProvider.getPort((World)this.conPos.getWorldServer(), this.conPos, this.conPin);
        if (lp instanceof MountedPort) {
            Connector c = ((MountedPort)lp).getConnector();
            if (c instanceof IIntegratedConnector) {
                return ((IIntegratedConnector)((Object)c)).getLinkedWith(this);
            }
            if (c instanceof WiredConnector && ((WiredConnector)c).conBeacon.getLink() == lid) {
                return (WiredConnector)c;
            }
        }
        return null;
    }

    public boolean isLinked(WiredConnector to) {
        int lid = this.conBeacon.getLink();
        return lid != 0 && lid == to.conBeacon.getLink();
    }

    protected void onWireRemoved(WiredConnector link, EntityPlayer player) {
        Connector con = this.port.getConnector();
        if (con == this) {
            this.port.setConnector(null, player);
        } else if (con instanceof IIntegratedConnector) {
            ((IIntegratedConnector)((Object)con)).removeWire(this, player);
        }
    }

    @Override
    public void onRemoved(EntityPlayer player) {
        block7: {
            Port p;
            WireLine line;
            try {
                line = new WireLine(this);
            }
            catch (WireLine.WireLoopException e) {
                break block7;
            }
            if (line.source != null && (p = line.source.getComPort()) != null) {
                p.disconnect();
            } else if (line.sink != null && (p = line.sink.getComPort()) != null) {
                p.disconnect();
            }
            for (WiredConnector con : line.hooks) {
                ((RelayPort)con.port).disconnect();
            }
        }
        WiredConnector con = this.getLink();
        if (con != null) {
            con.onWireRemoved(this, player);
        }
        this.conBeacon.disconnect();
    }

    public void connect(WiredConnector to) {
        WiredConnector con2;
        WireLine line;
        this.conBeacon.connect(to.conBeacon);
        try {
            line = new WireLine(this);
        }
        catch (WireLine.WireLoopException e) {
            return;
        }
        if (line.source == null || line.sink == null || !line.contains(to) || !line.checkTypes()) {
            return;
        }
        String label = null;
        Iterator<WiredConnector> iterator = line.iterator();
        while (iterator.hasNext() && (label = (con2 = iterator.next()).getTag()) == null) {
        }
        String label_ = label;
        line.forEach((Consumer<? super WiredConnector>)((Consumer<WiredConnector>)con -> con.setTag(label_)));
        Port sp = line.source.getComPort();
        sp.connect(line.sink.getComPort());
        for (WiredConnector rp : line.hooks) {
            ((RelayPort)rp.port).connect(sp);
        }
    }

    public Port getComPort() {
        Connector con = this.port.getConnector();
        if (con instanceof IIntegratedConnector) {
            return ((IIntegratedConnector)((Object)con)).getPort(this);
        }
        return this.port;
    }

    public abstract boolean isCompatible(Class<?> var1);

    @Override
    public void setTag(String tag) {
        if (Objects.equals(this.tag, tag)) {
            return;
        }
        this.tag = tag;
        this.port.owner.onPortModified(this.port, 16);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String displayInfo(MountedPort port, int linkID) {
        return this.tag != null ? "\n\u00a7e" + this.tag : super.displayInfo(port, linkID);
    }

    public static Vec3d getPath(MountedPort from, MountedPort to) {
        Vec3d path = new Vec3d((Vec3i)to.getPos().func_177973_b((Vec3i)from.getPos())).func_178787_e(to.pos.func_178788_d(from.pos));
        if (!(from instanceof RelayPort)) {
            path = path.func_178788_d(new Vec3d(from.face.func_176730_m()).func_186678_a(0.125));
        }
        if (!(to instanceof RelayPort)) {
            path = path.func_178787_e(new Vec3d(to.face.func_176730_m()).func_186678_a(0.125));
        }
        return path;
    }

    public static double getDistance(MountedPort from, MountedPort to) {
        return Math.sqrt(new DimPos((Vec3i)from.getPos(), from.getWorld()).func_177951_i((Vec3i)new DimPos((Vec3i)to.getPos(), to.getWorld())));
    }

    public static interface IWiredConnectorItem
    extends Connector.IConnectorItem {
        default public void doAttach(ItemStack stack, RelayPort port, EntityPlayer player) {
            this.doAttach(stack, (MountedPort)port, player);
        }
    }
}

