/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.wire;

import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.wire.RelayPort;
import cd4017be.api.rs_ctr.wire.WiredConnector;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;

public class WireLine
implements Collection<WiredConnector> {
    public final WiredConnector source;
    public final WiredConnector sink;
    public final WiredConnector[] hooks;

    public WireLine(WiredConnector con) throws WireLoopException {
        WiredConnector p1;
        ArrayDeque<WiredConnector> list = new ArrayDeque<WiredConnector>();
        WiredConnector p0 = WireLine.scan(con, list);
        WiredConnector wiredConnector = p1 = con.port instanceof RelayPort ? WireLine.scan((WiredConnector)((RelayPort)con.port).opposite.getConnector(), list) : con;
        if (con.conBeacon.isMaster) {
            this.source = p1;
            this.sink = p0;
        } else {
            this.source = p0;
            this.sink = p1;
        }
        this.hooks = list.toArray(new WiredConnector[list.size()]);
    }

    private static WiredConnector scan(WiredConnector con, ArrayDeque<WiredConnector> list) throws WireLoopException {
        WiredConnector con1;
        if (con == null) {
            return null;
        }
        boolean dir = con.conBeacon.isMaster;
        if (con.port instanceof RelayPort) {
            if (dir) {
                list.addLast(con);
            } else {
                list.addFirst(con);
            }
        }
        while ((con1 = con.getLink()) != null && con1.port instanceof RelayPort) {
            if (list.contains(con1)) {
                throw new WireLoopException();
            }
            if (dir) {
                list.addLast(con1);
            } else {
                list.addFirst(con1);
            }
            RelayPort sr = ((RelayPort)con1.port).opposite;
            Connector c = sr.getConnector();
            if (!(c instanceof WiredConnector)) {
                return null;
            }
            con = (WiredConnector)c;
            if (dir) {
                list.addLast(con);
                continue;
            }
            list.addFirst(con);
        }
        return con1;
    }

    public boolean checkTypes() {
        Class<?> type = null;
        if (this.source != null) {
            type = this.source.getComPort().type;
        }
        if (this.sink != null) {
            if (type == null) {
                type = this.sink.getComPort().type;
            } else if (this.sink.getComPort().type != type) {
                return false;
            }
        }
        if (type == null) {
            return true;
        }
        for (WiredConnector con : this.hooks) {
            if (con.isCompatible(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        int n = this.hooks.length;
        if (this.source != null) {
            ++n;
        }
        if (this.sink != null) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.source == null && this.sink == null && this.hooks.length == 0;
    }

    @Override
    public boolean contains(Object port) {
        if (port instanceof WiredConnector) {
            for (WiredConnector sr : this.hooks) {
                if (sr != port) continue;
                return true;
            }
            return port == this.source || port == this.sink;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<WiredConnector> iterator() {
        return new Iterator<WiredConnector>(){
            int i;
            int n;
            {
                this.i = WireLine.this.source != null ? -1 : 0;
                this.n = WireLine.this.hooks.length + (WireLine.this.sink != null ? 1 : 0);
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }

            @Override
            public WiredConnector next() {
                int j;
                return (j = this.i++) < 0 ? WireLine.this.source : (j < WireLine.this.hooks.length ? WireLine.this.hooks[j] : WireLine.this.sink);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super WiredConnector> action) {
        if (this.source != null) {
            action.accept(this.source);
        }
        for (WiredConnector con : this.hooks) {
            action.accept(con);
        }
        if (this.sink != null) {
            action.accept(this.sink);
        }
    }

    public MountedPort[] toArray() {
        return this.toArray(new MountedPort[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int n = this.size();
        if (a.length < n) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), n);
        }
        int i = 0;
        if (this.source != null) {
            a[i++] = this.source;
        }
        System.arraycopy(this.hooks, 0, a, i, this.hooks.length);
        if (this.source != null) {
            a[n - 1] = this.source;
        }
        return null;
    }

    @Override
    public boolean add(WiredConnector e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends WiredConnector> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static class WireLoopException
    extends Exception {
    }
}

