/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.port;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class MountedPort
extends Port
implements IInteractiveComponent {
    public static final float SIZE = 0.1f;
    public String name = "";
    public Vec3d pos = Vec3d.field_186680_a;
    public EnumFacing face = EnumFacing.NORTH;
    protected Connector connector;

    public MountedPort(IPortProvider owner, int pin, Class<?> type, boolean isSource) {
        super(owner, pin, type, isSource);
    }

    public MountedPort setLocation(double x, double y, double z, EnumFacing face) {
        World world;
        this.pos = new Vec3d(x, y, z);
        this.face = face;
        if (this.connector != null && (world = this.getWorld()) != null && !world.field_72995_K) {
            this.connector.onPortMove();
        }
        return this;
    }

    public MountedPort setLocation(double x, double y, double z, EnumFacing face, Orientation o) {
        Vec3d vec = o.rotate(new Vec3d(x - 0.5, y - 0.5, z - 0.5));
        return this.setLocation(vec.field_72450_a + 0.5, vec.field_72448_b + 0.5, vec.field_72449_c + 0.5, o.rotate(face));
    }

    public MountedPort setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        String s = TooltipUtil.translate(this.name);
        if (this.connector != null) {
            s = s + this.connector.displayInfo(this, this.linkID);
        } else if (this.linkID != 0) {
            s = s + "\nID " + this.linkID;
        }
        return Pair.of((Object)this.pos, (Object)s);
    }

    @Override
    public Pair<Vec3d, EnumFacing> rayTrace(Vec3d start, Vec3d dir) {
        return IInteractiveComponent.rayTraceFlat(start, dir, this.pos, this.face, 0.1f, 0.1f);
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        ItemStack stack = player.func_184614_ca();
        if (hit || player.func_70093_af() && stack.func_190926_b()) {
            this.setConnector(null, player);
            return true;
        }
        if (stack.func_77973_b() instanceof Connector.IConnectorItem) {
            ((Connector.IConnectorItem)stack.func_77973_b()).doAttach(stack, this, player);
            return true;
        }
        return false;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(@Nullable Connector c, @Nullable EntityPlayer by) {
        if (this.connector == c) {
            return;
        }
        Connector old = this.connector;
        this.connector = c;
        int ev = 0;
        if (old != null) {
            old.onUnload();
            old.onRemoved(by);
            ev |= 0x18;
        }
        if (c != null) {
            c.onLoad();
            ev |= 0x14;
        }
        this.owner.onPortModified(this, ev);
    }

    public <T> void addRenderComps(List<T> list, Class<T> type) {
        if (type.isInstance(this.connector)) {
            list.add(type.cast(this.connector));
        }
    }

    public boolean canMove() {
        return false;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        if (this.connector != null) {
            nbt.func_74782_a("con", (NBTBase)this.connector.serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.connector = Connector.load(nbt.func_74775_l("con"), this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.connector != null) {
            this.connector.onLoad();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.connector != null) {
            this.connector.onUnload();
        }
    }

    @Override
    protected void onLinkLoad(Port link) {
        if (this.connector != null) {
            this.connector.onLinkLoad(link);
        }
    }
}

