/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes.vanilla;

import cd4017be.api.recipes.ItemOperand;
import cd4017be.api.recipes.RecipeAPI;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.api.recipes.vanilla.IngredientIterator;
import cd4017be.lib.Lib;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.IOperand;
import com.google.common.base.Predicates;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingRecipeIterator
implements IOperand.OperandIterator {
    private Iterator<IRecipe> list;
    private final Predicate<Object> key;
    private final ItemStack item;
    private Array curElement;
    private IRecipe curRecipe;
    public static final Ingredient LOCK_INGRED = new Ingredient(new ItemStack[]{new ItemStack((Item)Lib.rrwi)}){

        public boolean apply(ItemStack stack) {
            return false;
        }
    };

    public CraftingRecipeIterator(ItemStack key) {
        this.list = CraftingManager.field_193380_a.iterator();
        this.key = Predicates.alwaysTrue();
        this.item = key;
    }

    public CraftingRecipeIterator(Predicate<Object> key) {
        this.key = key;
        this.item = null;
        this.list = CraftingManager.field_193380_a.iterator();
    }

    @Override
    public IOperand next() {
        return this.curElement;
    }

    @Override
    public void set(IOperand obj) {
        if (obj != this.curElement) {
            this.disableRecipe();
            return;
        }
        Object out = this.curElement.array[0].value();
        if (!(out instanceof ItemStack)) {
            throw new IllegalArgumentException("ItemStack expected");
        }
        if (out != this.curRecipe.func_77571_b()) {
            ItemStack item = (ItemStack)out;
            if (this.curRecipe instanceof ShapedRecipes) {
                ShapedRecipes sr = (ShapedRecipes)this.curRecipe;
                RecipeAPI.addRecipe(new ShapedRecipes(sr.func_193358_e(), sr.field_77576_b, sr.field_77577_c, CraftingRecipeIterator.copy((NonNullList<Ingredient>)sr.field_77574_d), item));
            } else if (this.curRecipe instanceof ShapelessRecipes) {
                ShapelessRecipes sr = (ShapelessRecipes)this.curRecipe;
                RecipeAPI.addRecipe(new ShapelessRecipes(sr.func_193358_e(), item, CraftingRecipeIterator.copy((NonNullList<Ingredient>)sr.field_77579_b)));
            } else if (this.curRecipe instanceof ShapedOreRecipe) {
                ShapedOreRecipe sr = (ShapedOreRecipe)this.curRecipe;
                CraftingHelper.ShapedPrimer p = new CraftingHelper.ShapedPrimer();
                p.width = sr.getRecipeWidth();
                p.height = sr.getRecipeHeight();
                p.input = CraftingRecipeIterator.copy((NonNullList<Ingredient>)sr.func_192400_c());
                RecipeAPI.addRecipe(new ShapedOreRecipe(new ResourceLocation(sr.func_193358_e()), item, p));
            } else if (this.curRecipe instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe sr = (ShapelessOreRecipe)this.curRecipe;
                RecipeAPI.addRecipe(new ShapelessOreRecipe(new ResourceLocation(sr.func_193358_e()), CraftingRecipeIterator.copy((NonNullList<Ingredient>)sr.func_192400_c()), item));
            } else {
                RecipeScriptContext.instance.LOG.warn(RecipeScriptContext.SCRIPT, "could not replicate unknown recipe type: {}!", this.curRecipe.getClass());
            }
            this.disableRecipe();
        }
    }

    private static NonNullList<Ingredient> copy(NonNullList<Ingredient> list) {
        NonNullList nlist = NonNullList.func_191196_a();
        nlist.addAll(list);
        return nlist;
    }

    private void disableRecipe() {
        NonNullList ingr = this.curRecipe.func_192400_c();
        int l = ingr.size();
        for (int i = 0; i < l; ++i) {
            ingr.set(i, LOCK_INGRED);
        }
    }

    @Override
    public boolean hasNext() {
        while (this.list.hasNext()) {
            this.curRecipe = this.list.next();
            ItemOperand result = new ItemOperand(this.curRecipe.func_77571_b());
            if (!this.key.test(result)) continue;
            IngredientIterator ingred = new IngredientIterator((NonNullList<Ingredient>)this.curRecipe.func_192400_c(), this.item, this.curRecipe instanceof IShapedRecipe);
            if (this.item != null) {
                if (!ingred.hasNext()) continue;
                ingred.reset();
            }
            this.curElement = new Array(result, ingred);
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.list = CraftingManager.field_193380_a.iterator();
    }

    @Override
    public Object value() {
        return this;
    }
}

